/******************************************************************************
 * %Id: ipr_bridge_if.h,v 1.19 2010/02/15 06:26:20 ishikawa Exp $
 *
 * FileName		:ipr_bridge_if.h
 *
 * Description	:I/F definition header for bridge (wrapper)
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_EXIV_BRIDGE_IF_H_
#define	_EXIV_BRIDGE_IF_H_



#define EXIV_L_DEVID_MAX_NUM	(EXIV_MINOR_NUM - 1)
#define EXIV_R_DEVID_MAX_NUM	(EXIV_MINOR_NUM - 1)
#define EXIV_MAX_FD_NAME		100



/***************/
/* API command */
/***************/
#define EXIV_IOC_INIT							IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  1 , sizeof(exiv_init_arg_t))
#define EXIV_IOC_TERM							IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  2 , sizeof(exiv_term_arg_t))
#define EXIV_IOC_OPEN							IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  3 , sizeof(exiv_open_arg_t))
#define EXIV_IOC_CLOSE							IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  4 , sizeof(exiv_close_arg_t))
#define EXIV_IOC_EXT_OPEN						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  5 , sizeof(exiv_open_arg_t))
#define EXIV_IOC_EXT_CLOSE						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  6 , sizeof(exiv_close_arg_t))
#define EXIV_IOC_SET_PORT						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  7 , sizeof(exiv_set_port_arg_t))
#define EXIV_IOC_GET_PORT						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  8 , sizeof(exiv_get_port_arg_t))
#define EXIV_IOC_SET_INPUT_FORMAT				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC,  9 , sizeof(exiv_set_input_format_arg_t))
#define EXIV_IOC_GET_INPUT_FORMAT				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 10 , sizeof(exiv_get_input_format_arg_t))
#define EXIV_IOC_SET_VIDEO_PLL_LEVEL			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 11 , sizeof(exiv_set_video_pll_level_arg_t))
#define EXIV_IOC_GET_VIDEO_PLL_LEVEL			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 12 , sizeof(exiv_get_video_pll_level_arg_t))
#define EXIV_IOC_SET_VIDEO_CGMS_POSITION		IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 13 , sizeof(exiv_set_video_cgms_position_arg_t))
#define EXIV_IOC_GET_VIDEO_CGMS_POSITION		IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 14 , sizeof(exiv_get_video_cgms_position_arg_t))
#define EXIV_IOC_SET_KILLER_ADJUST				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 15 , sizeof(exiv_set_killer_adjust_arg_t))
#define EXIV_IOC_GET_KILLER_ADJUST				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 16 , sizeof(exiv_get_killer_adjust_arg_t))
#define EXIV_IOC_SET_3DYC_ONOFF					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 17 , sizeof(exiv_set_3dyc_onoff_arg_t))
#define EXIV_IOC_GET_3DYC_ONOFF					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 18 , sizeof(exiv_get_3dyc_onoff_arg_t))
#define EXIV_IOC_HOLD_3DYC_OFF					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 19 , sizeof(exiv_hold_3dyc_off_arg_t))
#define EXIV_IOC_GET_HOLD_3DYC_OFF				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 20 , sizeof(exiv_get_hold_3dyc_off_arg_t))
#define EXIV_IOC_SET_3DYC_ADJUST				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 21 , sizeof(exiv_set_3dyc_adjust_arg_t))
#define EXIV_IOC_GET_3DYC_ADJUST				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 22 , sizeof(exiv_get_3dyc_adjust_arg_t))
#define EXIV_IOC_SET_SCART						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 23 , sizeof(exiv_set_scart_arg_t))
#define EXIV_IOC_GET_SCART_INFO					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 24 , sizeof(exiv_get_scart_info_arg_t))
#define EXIV_IOC_SET_AUTO_COLOR_SEARCH_ONOFF	IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 25 , sizeof(exiv_set_auto_color_search_onoff_arg_t))
#define EXIV_IOC_GET_AUTO_COLOR_SEARCH_ONOFF	IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 26 , sizeof(exiv_get_auto_color_search_onoff_arg_t))
#define EXIV_IOC_SET_VIDEO_SLICE_LEVEL			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 27 , sizeof(exiv_set_video_slice_level_arg_t))
#define EXIV_IOC_GET_VIDEO_SLICE_LEVEL			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 28 , sizeof(exiv_get_video_slice_level_arg_t))
#define EXIV_IOC_SET_VIDEO_DOT_CLOCK			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 29 , sizeof(exiv_set_video_dot_clock_arg_t))
#define EXIV_IOC_GET_VIDEO_DOT_CLOCK			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 30 , sizeof(exiv_get_video_dot_clock_arg_t))
#define EXIV_IOC_SET_VIDEO_CLOCK_PHASE			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 31 , sizeof(exiv_set_video_clock_phase_arg_t))
#define EXIV_IOC_GET_VIDEO_CLOCK_PHASE			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 32 , sizeof(exiv_get_video_clock_phase_arg_t))
#define EXIV_IOC_SET_HDMIRX_POWER				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 33 , sizeof(exiv_set_hdmirx_power_arg_t))
#define EXIV_IOC_GET_HDMIRX_POWER				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 34 , sizeof(exiv_get_hdmirx_power_arg_t))
#define EXIV_IOC_SET_HDMIRX_FREERUN				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 35 , sizeof(exiv_set_hdmirx_freerun_arg_t))
#define EXIV_IOC_GET_HDMIRX_FREERUN				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 36 , sizeof(exiv_get_hdmirx_freerun_arg_t))
#define EXIV_IOC_SET_HDMIRX_TMDS_EQUALIZER		IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 37 , sizeof(exiv_set_hdmirx_tmds_equalizer_arg_t))
#define EXIV_IOC_GET_HDMIRX_TMDS_EQUALIZER		IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 38 , sizeof(exiv_get_hdmirx_tmds_equalizer_arg_t))
#define EXIV_IOC_SET_OUTPUT_FORMAT				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 39 , sizeof(exiv_set_output_format_arg_t))
#define EXIV_IOC_GET_OUTPUT_FORMAT				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 40 , sizeof(exiv_get_output_format_arg_t))
#define EXIV_IOC_SET_VIDEO_MUTE					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 41 , sizeof(exiv_set_video_mute_arg_t))
#define EXIV_IOC_GET_VIDEO_MUTE					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 42 , sizeof(exiv_get_video_mute_arg_t))
#define EXIV_IOC_SET_VIDEO_LEVEL				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 43 , sizeof(exiv_set_video_level_arg_t))
#define EXIV_IOC_GET_VIDEO_LEVEL				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 44 , sizeof(exiv_get_video_level_arg_t))
#define EXIV_IOC_SET_MATRIX						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 45 , sizeof(exiv_set_matrix_arg_t))
#define EXIV_IOC_GET_MATRIX						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 46 , sizeof(exiv_get_matrix_arg_t))
#define EXIV_IOC_SELECT_VOUT_SRC				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 47 , sizeof(exiv_select_vout_src_arg_t))
#define EXIV_IOC_GET_VOUT_SRC					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 48 , sizeof(exiv_get_vout_src_arg_t))
#define EXIV_IOC_GET_INPUT_SIGNAL_INFO			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 49 , sizeof(exiv_get_input_signal_info_arg_t))
#define EXIV_IOC_SET_SIGNAL_CHANGE_NOTIFICATION	IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 50 , sizeof(exiv_set_signal_change_notification_arg_t))
#define EXIV_IOC_GET_SIGNAL_CHANGE_NOTIFICATION	IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 51 , sizeof(exiv_get_signal_change_notification_arg_t))
#define EXIV_IOC_GET_VIDEO_ASPECT_INFO			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 52 , sizeof(exiv_get_video_aspect_info_arg_t))
#define EXIV_IOC_MEASURE_PC_SIGNAL				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 53 , sizeof(exiv_measure_pc_signal_arg_t))
#define EXIV_IOC_MEASURE_PC_PHASE				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 54 , sizeof(exiv_measure_pc_phase_arg_t))
#define EXIV_IOC_GET_PC_INPUT_FORMAT			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 55 , sizeof(exiv_get_pc_input_format_arg_t))
#define EXIV_IOC_CLEAR_PC_FORMATS				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 56 , sizeof(exiv_clear_pc_formats_arg_t))
#define EXIV_IOC_ADD_PC_FORMAT					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 57 , sizeof(exiv_add_pc_format_arg_t))
#define EXIV_IOC_REMOVE_PC_FORMAT				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 58 , sizeof(exiv_remove_pc_format_arg_t))
#define EXIV_IOC_SET_PC_FORMAT					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 59 , sizeof(exiv_set_pc_format_arg_t))
#define EXIV_IOC_GET_PC_FORMAT					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 60 , sizeof(exiv_get_pc_format_arg_t))
#define EXIV_IOC_GET_HDMIRX_PACKET_INFO			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 61 , sizeof(exiv_get_hdmirx_packet_info_arg_t))
#define EXIV_IOC_START_VBI						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 62 , sizeof(exiv_start_vbi_arg_t))
#define EXIV_IOC_STOP_VBI						IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 63 , sizeof(exiv_stop_vbi_arg_t))
#define EXIV_IOC_SET_VPS_ACQ					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 64 , sizeof(exiv_set_vps_acq_arg_t))
#define EXIV_IOC_GET_VBI_INFO					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 65 , sizeof(exiv_get_vbi_info_arg_t))
#define EXIV_IOC_GET_VPS_ACQ					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 66 , sizeof(exiv_get_vps_acq_arg_t))
#define EXIV_IOC_SET_HDMIRX_CALLBACK			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 67 , sizeof(exiv_set_hdmirx_callback_arg_t))
#define EXIV_IOC_GET_HDMIRX_AUDIO_INFO			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 68 , sizeof(exiv_get_hdmirx_audio_info_arg_t))
#define EXIV_IOC_SET_VIDEO_HV_POSITION          IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 69 , sizeof(exiv_set_video_hv_position_arg_t))
#define EXIV_IOC_SET_CSC_ROUND                  IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 70 , sizeof(exiv_set_csc_round_arg_t))
#define EXIV_IOC_GET_STD_SIG_DET                IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 71 , sizeof(exiv_get_std_sig_det_arg_t))
#define EXIV_IOC_SET_FORMAT_DETECT              IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 72 , sizeof(exiv_set_format_detect_arg_t))
#define EXIV_IOC_SET_HDMIRX_RGB_MODE            IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 73 , sizeof(exiv_set_hdmirx_rgb_mode_arg_t))
#define EXIV_IOC_SET_HDMIRX_HDCP_AKE			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 74 , sizeof(exiv_set_hdmirx_hdcp_ake_arg_t))
#define EXIV_IOC_START_HDMIRX_HDCP_2ND_AKE		IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 75 , sizeof(exiv_start_hdmirx_hdcp_2nd_ake_arg_t))
#define EXIV_IOC_SET_HDMIRX_INSERT_VP           IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 76 , sizeof(exiv_set_hdmirx_insert_vp_arg_t))
#define EXIV_IOC_GET_HDMI_ENC					IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 77 , sizeof(exiv_get_hdmirx_enc_status_arg_t))
#define EXIV_IOC_SET_PLANE_OUTPUTMODE			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 78 , sizeof(exiv_set_plane_outputmode_arg_t))
#define EXIV_IOC_SELECT_SYNC_SRC				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 79 , sizeof(exiv_select_sync_src_arg_t))
#define EXIV_IOC_SET_HDMIRX_FAST_MODE			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 80 , sizeof(exiv_set_hdmirx_fast_mode_arg_t))
#define EXIV_IOC_SET_BACKUP_PORT                IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 81 , sizeof(exiv_set_backup_port_arg_t))
#define EXIV_IOC_SET_BACKUP_INPUT				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 82 , sizeof(exiv_set_backup_input_arg_t))
#define EXIV_IOC_GET_BACKUP_INPUT				IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 83 , sizeof(exiv_get_backup_input_arg_t))

/************/
/* CALLBACK */
/************/
#define EXIV_IOC_API_FINISH_CB			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 1 , sizeof(exiv_api_finish_cb_arg_t))
#define EXIV_IOC_CHANGE_NOTIFICATION_CB	IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 2 , sizeof(exiv_change_notification_cb_arg_t))
#define EXIV_IOC_VBI_SLICE_CB			IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 3 , sizeof(exiv_vbi_slice_cb_arg_t))
#define EXIV_IOC_HDMIRX_CALLBACK		IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 4 , sizeof(exiv_hdmirx_callback_info_arg_t))
#define EXIV_IOC_ANALOG_DMD_CALL		IOSC_DEFINE_RWCMD(L_EXIV_MAGIC, 5 , sizeof(exiv_set_analog_dmd_call_arg_t))


#endif	/* #ifndef	_EXIV_BRIDGE_IF_H_ */
